/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.util.auimlcvt;

import com.ibm.hwmca.fw.util.auimlcvt.OutputXML;
import java.io.IOException;
import java.io.InputStream;
import org.w3c.dom.Document;

public class DocumentInputStream
extends InputStream {
    private String source;
    private int sourceLen;
    private int currentPos;
    private int mark;
    private boolean closed;

    public DocumentInputStream(Document document) {
        this.source = OutputXML.buildStringFromXML(document);
        this.sourceLen = this.source.length();
        this.mark = -1;
        this.closed = false;
    }

    public int read() throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed.");
        }
        if (this.currentPos >= this.sourceLen) {
            return -1;
        }
        return this.source.charAt(this.currentPos++);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new IllegalArgumentException("Data buffer may not be null.");
        }
        if (this.closed) {
            throw new IOException("Stream is closed.");
        }
        if (this.currentPos >= this.sourceLen) {
            return -1;
        }
        int bytesRead = 0;
        try {
            int i = off;
            while (i < len) {
                b[i] = (byte)this.source.charAt(this.currentPos++);
                ++bytesRead;
                ++i;
            }
        }
        catch (StringIndexOutOfBoundsException sioobe) {}
        return bytesRead;
    }

    public int read(byte[] b) throws IOException {
        if (b == null) {
            throw new IllegalArgumentException("Data buffer may not be null.");
        }
        if (this.closed) {
            throw new IOException("Stream is closed.");
        }
        if (this.currentPos >= this.sourceLen) {
            return -1;
        }
        int bytesRead = 0;
        try {
            int i = 0;
            while (i < b.length) {
                b[i] = (byte)this.source.charAt(this.currentPos++);
                ++bytesRead;
                ++i;
            }
        }
        catch (StringIndexOutOfBoundsException sioobe) {}
        return bytesRead;
    }

    public synchronized void mark(int readlimit) {
        this.mark = this.currentPos;
    }

    public long skip(long n) throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed.");
        }
        long available = this.sourceLen - this.currentPos;
        long returnVal = n < available ? n : available;
        this.currentPos = (int)((long)this.currentPos + returnVal);
        return returnVal;
    }

    public int available() throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed.");
        }
        return this.sourceLen - this.currentPos;
    }

    public void close() throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed.");
        }
        this.source = null;
        this.sourceLen = 0;
        this.currentPos = 0;
    }

    public synchronized void reset() throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed.");
        }
        this.currentPos = this.mark;
        this.mark = -1;
    }

    public boolean markSupported() {
        return true;
    }
}

